#!/bin/bash -x

set -e

gmssl sm4 -help

# CBC
echo hello | gmssl sm4 -cbc -encrypt -key 11223344556677881122334455667788 -iv 11223344556677881122334455667788 -out ciphertext.bin
gmssl sm4 -cbc -decrypt -key 11223344556677881122334455667788 -iv 11223344556677881122334455667788 -in ciphertext.bin

# CTR
echo hello | gmssl sm4 -ctr -encrypt -key 11223344556677881122334455667788 -iv 11223344556677881122334455667788 -out ciphertext.bin
gmssl sm4 -ctr -decrypt -key 11223344556677881122334455667788 -iv 11223344556677881122334455667788 -in ciphertext.bin

# GCM IV length = 12
echo hello | gmssl sm4 -gcm -encrypt -key 11223344556677881122334455667788 -iv 112233445566778811223344 -out ciphertext.bin
gmssl sm4 -gcm -decrypt -key 11223344556677881122334455667788 -iv 112233445566778811223344 -in ciphertext.bin

# GCM IV length = 1
echo hello | gmssl sm4 -gcm -encrypt -key 11223344556677881122334455667788 -iv 11 -out ciphertext.bin
gmssl sm4 -gcm -decrypt -key 11223344556677881122334455667788 -iv 11 -in ciphertext.bin

# GCM IV length = 16
echo hello | gmssl sm4 -gcm -encrypt -key 11223344556677881122334455667788 -iv 11223344556677881122334455667788 -out ciphertext.bin
gmssl sm4 -gcm -decrypt -key 11223344556677881122334455667788 -iv 11223344556677881122334455667788 -in ciphertext.bin

# GCM IV length = 32
echo hello | gmssl sm4 -gcm -encrypt -key 11223344556677881122334455667788 -iv 1122334455667788112233445566778811223344556677881122334455667788 -out ciphertext.bin
gmssl sm4 -gcm -decrypt -key 11223344556677881122334455667788 -iv 1122334455667788112233445566778811223344556677881122334455667788 -in ciphertext.bin

# CBC-SM3-HMAC
echo hello | gmssl sm4 -cbc_sm3_hmac -encrypt \
	-key 112233445566778811223344556677881122334455667788112233445566778811223344556677881122334455667788 \
	-iv 11223344556677881122334455667788 -out ciphertext.bin
gmssl sm4 -cbc_sm3_hmac -decrypt \
	-key 112233445566778811223344556677881122334455667788112233445566778811223344556677881122334455667788 \
	 -iv 11223344556677881122334455667788 -in ciphertext.bin

# CTR-SM3-HMAC
echo hello | gmssl sm4 -ctr_sm3_hmac -encrypt \
	-key 112233445566778811223344556677881122334455667788112233445566778811223344556677881122334455667788 \
	-iv 11223344556677881122334455667788 -out ciphertext.bin
gmssl sm4 -ctr_sm3_hmac -decrypt \
	-key 112233445566778811223344556677881122334455667788112233445566778811223344556677881122334455667788 \
	 -iv 11223344556677881122334455667788 -in ciphertext.bin

# encrypt/decrypt long text file

cat << EOF > plaintext.txt
-----BEGIN CERTIFICATE-----
MIICzzCCAnKgAwIBAgIFEzY5M3AwDAYIKoEcz1UBg3UFADAlMQswCQYDVQQGEwJD
TjEWMBQGA1UECgwNQ0ZDQSBTTTIgT0NBMTAeFw0yMTA2MTEwOTA1MjBaFw0yNjA2
MTkwODE2NTZaMIGRMQswCQYDVQQGEwJDTjEPMA0GA1UECAwG5YyX5LqsMQ8wDQYD
VQQHDAbljJfkuqwxJzAlBgNVBAoMHuS4reWbvemTtuihjOiCoeS7veaciemZkOWF
rOWPuDERMA8GA1UECwwITG9jYWwgUkExDDAKBgNVBAsMA1NTTDEWMBQGA1UEAwwN
ZWJzc2VjLmJvYy5jbjBZMBMGByqGSM49AgEGCCqBHM9VAYItA0IABPsNUnoZQM9C
SnvC57TbvdfyOTCuPOSlZmPAyxBKFj+Y1QH/xlubHdVf5XqHrO1jCDRi7aN5IKGX
QF1492c803OjggEeMIIBGjAfBgNVHSMEGDAWgBRck1ggWiRzVhAbZFAQ7OmnygdB
ETAMBgNVHRMBAf8EAjAAMEgGA1UdIARBMD8wPQYIYIEchu8qAQEwMTAvBggrBgEF
BQcCARYjaHR0cDovL3d3dy5jZmNhLmNvbS5jbi91cy91cy0xNC5odG0wNwYDVR0f
BDAwLjAsoCqgKIYmaHR0cDovL2NybC5jZmNhLmNvbS5jbi9TTTIvY3JsNTYxOC5j
cmwwGAYDVR0RBBEwD4INZWJzc2VjLmJvYy5jbjAOBgNVHQ8BAf8EBAMCBsAwHQYD
VR0OBBYEFJ6oFo/OrKgDhHFORpaq04kX7T1KMB0GA1UdJQQWMBQGCCsGAQUFBwMC
BggrBgEFBQcDATAMBggqgRzPVQGDdQUAA0kAMEYCIQCvhSvbv5h6ERl1YcCLg+fz
9UleQbaPfBYwUjUD2dAHVQIhAMRC4k9S/mSC0UpUvCqh/DQC2Ui8Tccd5G2IgYSs
cnUN
-----END CERTIFICATE-----
EOF


# CBC
gmssl sm4 -cbc -encrypt -key 11223344556677881122334455667788 -iv 11223344556677881122334455667788 -in plaintext.txt -out ciphertext.bin
gmssl sm4 -cbc -decrypt -key 11223344556677881122334455667788 -iv 11223344556677881122334455667788 -in ciphertext.bin

# CTR
gmssl sm4 -ctr -encrypt -key 11223344556677881122334455667788 -iv 11223344556677881122334455667788 -in plaintext.txt -out ciphertext.bin
gmssl sm4 -ctr -decrypt -key 11223344556677881122334455667788 -iv 11223344556677881122334455667788 -in ciphertext.bin

# GCM IV length = 12
gmssl sm4 -gcm -encrypt -key 11223344556677881122334455667788 -iv 112233445566778811223344 -in plaintext.txt -out ciphertext.bin
gmssl sm4 -gcm -decrypt -key 11223344556677881122334455667788 -iv 112233445566778811223344 -in ciphertext.bin

# GCM IV length = 1
gmssl sm4 -gcm -encrypt -key 11223344556677881122334455667788 -iv 11 -in plaintext.txt -out ciphertext.bin
gmssl sm4 -gcm -decrypt -key 11223344556677881122334455667788 -iv 11 -in ciphertext.bin

# GCM IV length = 16
gmssl sm4 -gcm -encrypt -key 11223344556677881122334455667788 -iv 11223344556677881122334455667788 -in plaintext.txt -out ciphertext.bin
gmssl sm4 -gcm -decrypt -key 11223344556677881122334455667788 -iv 11223344556677881122334455667788 -in ciphertext.bin

# GCM IV length = 32
gmssl sm4 -gcm -encrypt -key 11223344556677881122334455667788 -iv 1122334455667788112233445566778811223344556677881122334455667788 -in plaintext.txt -out ciphertext.bin
gmssl sm4 -gcm -decrypt -key 11223344556677881122334455667788 -iv 1122334455667788112233445566778811223344556677881122334455667788 -in ciphertext.bin

# CBC-SM3-HMAC
gmssl sm4 -cbc_sm3_hmac -encrypt \
	-key 112233445566778811223344556677881122334455667788112233445566778811223344556677881122334455667788 \
	-iv 11223344556677881122334455667788 -in plaintext.txt -out ciphertext.bin
gmssl sm4 -cbc_sm3_hmac -decrypt \
	-key 112233445566778811223344556677881122334455667788112233445566778811223344556677881122334455667788 \
	 -iv 11223344556677881122334455667788 -in ciphertext.bin

# CTR-SM3-HMAC
gmssl sm4 -ctr_sm3_hmac -encrypt \
	-key 112233445566778811223344556677881122334455667788112233445566778811223344556677881122334455667788 \
	-iv 11223344556677881122334455667788 -in plaintext.txt -out ciphertext.bin
gmssl sm4 -ctr_sm3_hmac -decrypt \
	-key 112233445566778811223344556677881122334455667788112233445566778811223344556677881122334455667788 \
	 -iv 11223344556677881122334455667788 -in ciphertext.bin


rm -fr plaintext.txt
rm -fr ciphertext.bin


